within PowerGrids.UsersGuide;

package Tutorial
  extends Modelica.Icons.Information;




  annotation(
    preferredView = "info",
    Documentation(info = "<html>
<p>This tutorial is meant to introduce beginners to the design and rationale of the PowerGrids library and to guide them through a series of examples that illustrate the library features, the system modelling patterns, and ultimately the way one can write his own component models.</p>
<p>The <a href=\"modelica://PowerGrids.UsersGuide.Tutorial.LibraryArchitecture\">Library Architecture</a> section introduces the basic principles and concepts behind the design of the library.</p>
<p>The <a href=\"modelica://PowerGrids.UsersGuide.Tutorial.ModelicaToolSupport\">Modelica Tool Support</a> section discusses the support of the PowerGrids library by various Modelica tools and how they must be set up to work correctly and efficiently with this library. </p>
<p>The <a href=\"modelica://PowerGrids.UsersGuide.Tutorial.Examples\">Examples</a> section demonstrates the use of the library components and of various features of the library through a series of examples of increasing complexity.</p>
<p>This tutorial contains hyperlinks to component and system models; you are invited to explore their documentation and their source code as a part of the Tutorial Experience.</p>
</html>"));
end Tutorial;
